<?php
$cacheFile = __DIR__ . '/cache.json';

// Redirect instantly using current cache
if (file_exists($cacheFile)) {
    $cache = json_decode(file_get_contents($cacheFile), true);
    if (isset($cache['store']) && !empty($cache['store'])) {

        // Trigger refresh in background (HTTP non-blocking)
        $refreshURL = 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/refresh_cache.php';

        // Fire and forget using HTTP request
        $ch = curl_init($refreshURL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT_MS, 100); // 100ms timeout, just fire and forget
        curl_exec($ch);
        curl_close($ch);

        // Redirect visitor
        header("Location: " . $cache['store']);
        exit;
    }
}

echo "No store available.";